//(c) uARM project    https://github.com/uARM-Palm/uARM    uARM@dmitry.gr

#include "palmos.h"
#include <stdio.h>

struct OsCall {
	uint8_t tab;
	uint16_t func;
	const char *name;
};

static const struct OsCall mPalmOsCalls[] = {
	{4, 0x000, "DALGetGlobalsPtr"},
	{4, 0x004, "HALDbgBreak"},
	{4, 0x008, "HALDbgMessage"},
	{4, 0x00C, "HALAttnGetLEDAttributes"},
	{4, 0x010, "HALAttnGetVibrateAttributes"},
	{4, 0x014, "HALAttnSetLEDAttributes"},
	{4, 0x018, "HALAttnSetVibrateAttributes"},
	{4, 0x01C, "HALBatteryGetInfo"},
	{4, 0x020, "HALBatteryGetValidKinds"},
	{4, 0x024, "HALBatterySetInfo"},
	{4, 0x028, "HALDelay"},
	{4, 0x02C, "HALDisplayGetAttributes"},
	{4, 0x030, "HALDisplayGetPalette"},
	{4, 0x034, "HALDisplaySetAttributes"},
	{4, 0x038, "HALDisplaySetPalette"},
	{4, 0x03C, "HALDisplayDoze"},
	{4, 0x040, "HALDisplayWake"},
	{4, 0x044, "HALDisplayLock"},
	{4, 0x048, "HALDisplayUnlock"},
	{4, 0x04C, "HALDockStatus"},
	{4, 0x050, "HALDrawInit"},
	{4, 0x074, "HALErrDisplay"},
	{4, 0x078, "HALEventPost"},
	{4, 0x07C, "HALEventRegisterCallBack"},
	{4, 0x080, "HALFlpAddDouble"},
	{4, 0x084, "HALFlpAddFloat"},
	{4, 0x088, "HALFlpCompareDoubleEqual"},
	{4, 0x08C, "HALFlpCompareDoubleLessThan"},
	{4, 0x090, "HALFlpCompareFloatEqual"},
	{4, 0x094, "HALFlpCompareFloatLessThan"},
	{4, 0x098, "HALFlpDivDouble"},
	{4, 0x09C, "HALFlpDivFloat"},
	{4, 0x0A0, "HALFlpDoubleToFloat"},
	{4, 0x0A4, "HALFlpDoubleToInt32"},
	{4, 0x0A8, "HALFlpDoubleToLongDouble"},
	{4, 0x0AC, "HALFlpDoubleToLongLong"},
	{4, 0x0B0, "HALFlpDoubleToUInt32"},
	{4, 0x0B4, "HALFlpDoubleToULongLong"},
	{4, 0x0B8, "HALFlpFloatToDouble"},
	{4, 0x0BC, "HALFlpFloatToInt32"},
	{4, 0x0C0, "HALFlpFloatToLongDouble"},
	{4, 0x0C4, "HALFlpFloatToLongLong"},
	{4, 0x0C8, "HALFlpFloatToUInt32"},
	{4, 0x0CC, "HALFlpFloatToULongLong"},
	{4, 0x0D0, "HALFlpInt32ToDouble"},
	{4, 0x0D4, "HALFlpInt32ToFloat"},
	{4, 0x0D8, "HALFlpLongDoubleToDouble"},
	{4, 0x0DC, "HALFlpLongDoubleToFloat"},
	{4, 0x0E0, "HALFlpLongLongToDouble"},
	{4, 0x0E4, "HALFlpLongLongToFloat"},
	{4, 0x0E8, "HALFlpMulDouble"},
	{4, 0x0EC, "HALFlpMulFloat"},
	{4, 0x0F0, "HALFlpNegDouble"},
	{4, 0x0F4, "HALFlpNegFloat"},
	{4, 0x0F8, "HALFlpSubDouble"},
	{4, 0x0FC, "HALFlpSubFloat"},
	{4, 0x100, "HALFlpUInt32ToDouble"},
	{4, 0x104, "HALFlpUInt32ToFloat"},
	{4, 0x108, "HALFlpULongLongToDouble"},
	{4, 0x10C, "HALFlpULongLongToFloat"},
	{4, 0x110, "HALGetHwrMiscFlags"},
	{4, 0x114, "HALGetHwrMiscFlagsExt"},
	{4, 0x118, "HALGetHwrWakeUp"},
	{4, 0x11C, "HALInterruptAllSetStatus"},
	{4, 0x120, "HALInterruptAllGetStatus"},
	{4, 0x124, "HALInterruptGetHandler"},
	{4, 0x128, "HALInterruptSetHandler"},
	{4, 0x12C, "HALInterruptSetState"},
	{4, 0x130, "HALKeyGetRates"},
	{4, 0x134, "HALKeyGetState"},
	{4, 0x138, "HALKeyResetDoubleTap"},
	{4, 0x13C, "HALKeySetMask"},
	{4, 0x140, "HALKeySetRates"},
	{4, 0x144, "HALMemoryGetMemoryMap"},
	{4, 0x148, "HALMemoryGetStorageAreaProtectionState"},
	{4, 0x14C, "HALMemorySetStorageAreaProtectionState"},
	{4, 0x150, "HALMemoryValidateArea"},
	{4, 0x154, "HALMemoryGetAreaSize"},
	{4, 0x158, "HALPenCalibrate"},
	{4, 0x15C, "HALPenRawToScreen"},
	{4, 0x160, "HALPenResetCalibration"},
	{4, 0x164, "HALPenGetPosition"},
	{4, 0x168, "HALPenScreenToRaw"},
	{4, 0x16C, "HALPowerGetAutoOffEvtTime"},
	{4, 0x170, "HALPowerGetAutoOffSeconds"},
	{4, 0x174, "HALPowerSetAutoOffEvtTime"},
	{4, 0x178, "HALPowerSetAutoOffSeconds"},
	{4, 0x17C, "HALPowerSleepReady"},
	{4, 0x180, "HALProcessorID"},
	{4, 0x184, "HALRandomGetBits"},
	{4, 0x188, "HALRandomInitializeSeed"},
	{4, 0x18C, "HALReset"},
	{4, 0x190, "HALScreenDefaultPalette"},
	{4, 0x194, "HALScreenDrawNotify"},
	{4, 0x198, "HALScreenGetColortable"},
	{4, 0x19C, "HALScreenInit"},
	{4, 0x1A0, "HALScreenLock"},
	{4, 0x1A4, "HALScreenPalette"},
	{4, 0x1A8, "HALScreenSendUpdateArea"},
	{4, 0x1AC, "HALScreenUnlock"},
	{4, 0x1B0, "HALScreenUpdateBitmap"},
	{4, 0x1B4, "HALSetInitStage"},
	{4, 0x1B8, "HALSetHwrMiscFlags"},
	{4, 0x1BC, "HALSilkscreenGetID"},
	{4, 0x1C0, "HALSoundOff"},
	{4, 0x1C4, "HALSoundPlay"},
	{4, 0x1C8, "HALTimeGetAlarm"},
	{4, 0x1CC, "HALTimeGetSeconds"},
	{4, 0x1D0, "HALTimeGetSystemTime"},
	{4, 0x1D4, "HALTimeGetSystemTimerInterval"},
	{4, 0x1D8, "HALTimeSetAlarm"},
	{4, 0x1DC, "HALTimeSetSeconds"},
	{4, 0x1E0, "HALTraceInit"},
	{4, 0x1E4, "HALTraceClose"},
	{4, 0x1E8, "HALTraceOutputT"},
	{4, 0x1EC, "HALTraceOutputTL"},
	{4, 0x1F0, "HALTraceOutputVT"},
	{4, 0x1F4, "HALTraceOutputVTL"},
	{4, 0x1F8, "HALTraceOutputB"},
	{4, 0x1FC, "HALOEMGetCompanyID"},
	{4, 0x200, "HALOEMGetHALID"},
	{4, 0x204, "HALOEMGetDeviceID"},
	{4, 0x208, "HwrCalcDynamicHeapSize"},
	{4, 0x20C, "HwrCalcDynamicRAMSize"},
	{4, 0x210, "HALDisplayDrawBootScreen"},
	{4, 0x214, "HALGetROMToken"},
	{4, 0x218, "KALEventGroupClear"},
	{4, 0x21C, "KALEventGroupCreate"},
	{4, 0x220, "KALEventGroupDelete"},
	{4, 0x224, "KALEventGroupRead"},
	{4, 0x228, "KALEventGroupSignal"},
	{4, 0x22C, "KALEventGroupWait"},
	{4, 0x230, "KALEventGroupGetInfo"},
	{4, 0x234, "KALMailboxCreate"},
	{4, 0x238, "KALMailboxDelete"},
	{4, 0x23C, "KALMailboxSend"},
	{4, 0x240, "KALMailboxWait"},
	{4, 0x244, "KALMailboxGetInfo"},
	{4, 0x248, "KALMutexCreate"},
	{4, 0x24C, "KALMutexDelete"},
	{4, 0x250, "KALMutexRelease"},
	{4, 0x254, "KALMutexReserve"},
	{4, 0x258, "KALMutexGetInfo"},
	{4, 0x25C, "KALSemaphoreCreate"},
	{4, 0x260, "KALSemaphoreDelete"},
	{4, 0x264, "KALSemaphoreSignal"},
	{4, 0x268, "KALSemaphoreWait"},
	{4, 0x26C, "KALSemaphoreGetInfo"},
	{4, 0x270, "KALTaskCreate"},
	{4, 0x274, "KALTaskDelay"},
	{4, 0x278, "KALTaskDelete"},
	{4, 0x27C, "KALTaskGetCurrentID"},
	{4, 0x280, "KALTaskGetInfo"},
	{4, 0x284, "KALTaskResume"},
	{4, 0x288, "KALTaskSuspend"},
	{4, 0x28C, "KALTaskStart"},
	{4, 0x290, "KALTaskSwitching"},
	{4, 0x294, "KALTaskWait"},
	{4, 0x298, "KALTaskWaitClr"},
	{4, 0x29C, "KALTaskWake"},
	{4, 0x2A0, "KALTaskExit"},
	{4, 0x2A4, "KALTimerCreate"},
	{4, 0x2A8, "KALTimerDelete"},
	{4, 0x2AC, "KALTimerSet"},
	{4, 0x2B0, "KALTimerGetInfo"},
	{4, 0x2B4, "RALCallWithNewStack"},
	{4, 0x2B8, "RALGetEntryAddresses"},
	{4, 0x2BC, "RALGetModuleInfo"},
	{4, 0x2C0, "RALGetStaticBase"},
	{4, 0x2C4, "RALLinkClient"},
	{4, 0x2C8, "RALLoadModule"},
	{4, 0x2CC, "RALPatchEntry"},
	{4, 0x2D0, "RALSetA5"},
	{4, 0x2D4, "RALUnloadModule"},
	{4, 0x2D8, "RALUnloadNext"},
	{4, 0x2DC, "DALSetDbgLockout"},
	{4, 0x2E0, "HALKeyGetDoubleTapDelay"},
	{4, 0x2E4, "HALKeySetDoubleTapDelay"},
	{4, 0x2E8, "HALInvalidateICache"},
	{4, 0x2EC, "HALHandleReset"},
	{4, 0x2F8, "HALDraw_Bitmap"},
	{4, 0x2FC, "HALDraw_FindIndexes"},
	{4, 0x300, "HALDraw_GetPixel"},
	{4, 0x304, "HALDraw_Chars"},
	{4, 0x308, "HALDraw_Line"},
	{4, 0x30C, "HALDraw_Rectangle"},
	{4, 0x310, "HALDraw_Pixels"},
	{4, 0x314, "HALSoundOpen"},
	{4, 0x318, "HALSoundClose"},
	{4, 0x31C, "HALSoundRead"},
	{4, 0x320, "HALSoundWrite"},
	{4, 0x324, "HALSoundIoctl"},
	{4, 0x328, "HALSoundInitialize"},
	{4, 0x32C, "HALSoundDispose"},
	{4, 0x330, "dprintf"},
	{4, 0x334, "HALDraw_GetSupportedDensity"},
	{4, 0x338, "HALPlaySmf"},
	{4, 0x358, "HALDisplaySleep"},
	{4, 0x33C, "OEMReserved1"},
	{4, 0x340, "OEMReserved2"},
	{4, 0x344, "OEMReserved3"},
	{4, 0x348, "OEMReserved4"},
	{4, 0x34C, "OEMReserved5"},
	{4, 0x350, "OEMReserved6"},
	{4, 0x354, "OEMReserved7"},
	{4, 0x35C, "OEMReserved8"},
	{4, 0x360, "OEMReserved9"},
	{4, 0x364, "OEMReserved10"},
	{4, 0x368, "OEMReserved11"},
	{4, 0x36C, "OEMReserved12"},
	{4, 0x370, "OEMReserved13"},
	{4, 0x374, "OEMReserved14"},
	{4, 0x378, "OEMReserved15"},
	{4, 0x37C, "OEMReserved16"},
	{4, 0x380, "OEMReserved17"},
	{4, 0x384, "OEMReserved18"},
	{4, 0x388, "OEMReserved19"},
	{4, 0x38C, "OEMReserved20"},
	{4, 0x390, "OEMReserved21"},
	{4, 0x394, "OEMReserved22"},
	{4, 0x398, "OEMReserved23"},
	{4, 0x39C, "OEMReserved24"},
	{4, 0x3A0, "OEMReserved25"},
	{4, 0x3A4, "OEMReserved26"},
	{4, 0x3A8, "OEMReserved27"},
	{4, 0x3AC, "OEMReserved28"},
	{4, 0x3B0, "OEMReserved29"},
	{4, 0x3B4, "OEMReserved30"},
	{4, 0x3B8, "OEMReserved31"},
	{4, 0x3BC, "OEMReserved32"},
	{8, 0x000, "PalmOSMain"},
	{8, 0x004, "PalmOSGetGlobalsPtr"},
	{8, 0x008, "AlmAlarmCallback"},
	{8, 0x00C, "AlmCancelAll"},
	{8, 0x010, "AlmDisplayAlarm"},
	{8, 0x014, "AlmEnableNotification"},
	{8, 0x018, "AlmGetAlarm"},
	{8, 0x01C, "AlmGetAlarmV40"},
	{8, 0x020, "AlmInit"},
	{8, 0x024, "AlmSetAlarm"},
	{8, 0x028, "AlmSetAlarmV40"},
	{8, 0x02C, "AlmTimeChange"},
	{8, 0x030, "AttnGetAttentionV40"},
	{8, 0x034, "AttnUpdateV40"},
	{8, 0x038, "AttnForgetItV40"},
	{8, 0x03C, "AttnGetCountsV40"},
	{8, 0x040, "AttnIterateV40"},
	{8, 0x044, "BmpBitsSize"},
	{8, 0x048, "BmpColortableSize"},
	{8, 0x04C, "BmpCompress"},
	{8, 0x050, "BmpCreate"},
	{8, 0x054, "BmpDelete"},
	{8, 0x058, "BmpGetBitDepth"},
	{8, 0x05C, "BmpGetBits"},
	{8, 0x060, "BmpGetColortable"},
	{8, 0x064, "BmpGetDimensions"},
	{8, 0x068, "BmpGetNextBitmap"},
	{8, 0x06C, "BmpGetSizes"},
	{8, 0x070, "BmpSize"},
	{8, 0x074, "CncAddProfile"},
	{8, 0x078, "CncDeleteProfile"},
	{8, 0x07C, "CncGetProfileInfo"},
	{8, 0x080, "CncGetProfileList"},
	{8, 0x084, "CncProfileCloseDB"},
	{8, 0x088, "CncProfileCount"},
	{8, 0x08C, "CncProfileCreate"},
	{8, 0x090, "CncProfileDelete"},
	{8, 0x094, "CncProfileGetCurrent"},
	{8, 0x098, "CncProfileGetIDFromIndex"},
	{8, 0x09C, "CncProfileGetIDFromName"},
	{8, 0x0A0, "CncProfileGetIndex"},
	{8, 0x0A4, "CncProfileOpenDB"},
	{8, 0x0A8, "CncProfileSetCurrent"},
	{8, 0x0AC, "CncProfileSettingGet"},
	{8, 0x0B0, "CncProfileSettingSet"},
	{8, 0x0B4, "CnvInPlaceSwapNBytes"},
	{8, 0x0B8, "CnvReadSwappedNBytes"},
	{8, 0x0BC, "CnvWriteSwappedNBytes"},
	{8, 0x0C0, "CnvReadARMStructureFrom68KFormat"},
	{8, 0x0C4, "CnvWriteARMStructureTo68KFormat"},
	{8, 0x0C8, "Crc16CalcBlock"},
	{8, 0x0CC, "DateAdjust"},
	{8, 0x0D0, "DateDaysToDate"},
	{8, 0x0D4, "DateSecondsToDate"},
	{8, 0x0D8, "DateTemplateToAscii"},
	{8, 0x0DC, "DateToAscii"},
	{8, 0x0E0, "DateToDays"},
	{8, 0x0E4, "DateToDOWDMFormat"},
	{8, 0x0E8, "DayOfMonth"},
	{8, 0x0EC, "DayOfWeek"},
	{8, 0x0F0, "DaysInMonth"},
	{8, 0x0F4, "DbgMessage"},
	{8, 0x0F8, "DbgBreak"},
	{8, 0x0FC, "DlkControl"},
	{8, 0x100, "DlkDispatchRequest"},
	{8, 0x104, "DlkGetSyncInfo"},
	{8, 0x108, "DlkSetLogEntry"},
	{8, 0x10C, "DlkStartServer"},
	{8, 0x110, "DmArchiveRecord"},
	{8, 0x114, "DmAttachRecord"},
	{8, 0x118, "DmAttachResource"},
	{8, 0x11C, "DmCloseDatabase"},
	{8, 0x120, "DmCreateDatabase"},
	{8, 0x124, "DmCreateDatabaseFromImage"},
	{8, 0x128, "DmCreateDatabaseV40"},
	{8, 0x12C, "DmDatabaseInfo"},
	{8, 0x130, "DmDatabaseInfoV40"},
	{8, 0x134, "DmDatabaseProtect"},
	{8, 0x138, "DmDatabaseProtectV40"},
	{8, 0x13C, "DmDatabaseSize"},
	{8, 0x140, "DmDatabaseSizeV40"},
	{8, 0x144, "DmDeleteCategory"},
	{8, 0x148, "DmDeleteDatabase"},
	{8, 0x14C, "DmDeleteDatabaseV40"},
	{8, 0x150, "DmDeleteRecord"},
	{8, 0x154, "DmDetachRecord"},
	{8, 0x158, "DmDetachResource"},
	{8, 0x15C, "DmFindDatabase"},
	{8, 0x160, "DmFindDatabaseV40"},
	{8, 0x164, "DmFindDatabaseWithTypeCreatorV40"},
	{8, 0x168, "DmFindDatabaseWithTypeCreator"},
	{8, 0x16C, "DmFindRecordByID"},
	{8, 0x170, "DmFindResource"},
	{8, 0x174, "DmFindResourceType"},
	{8, 0x178, "DmFindSortPosition"},
	{8, 0x17C, "DmFindSortPositionV10"},
	{8, 0x180, "DmGet1Resource"},
	{8, 0x184, "DmGetAppInfoH"},
	{8, 0x188, "DmGetDatabase"},
	{8, 0x18C, "DmGetDatabaseLockState"},
	{8, 0x190, "DmGetDatabaseV40"},
	{8, 0x194, "DmGetLastErr"},
	{8, 0x198, "DmGetNextDatabaseByTypeCreator"},
	{8, 0x19C, "DmGetNextDatabaseByTypeCreatorV40"},
	{8, 0x1A0, "DmGetRecord"},
	{8, 0x1A4, "DmGetResource"},
	{8, 0x1A8, "DmGetResourceIndex"},
	{8, 0x1AC, "DmInit"},
	{8, 0x1B0, "DmInsertionSort"},
	{8, 0x1B4, "DmMoveCategory"},
	{8, 0x1B8, "DmMoveOpenDBContext"},
	{8, 0x1BC, "DmMoveRecord"},
	{8, 0x1C0, "DmNewHandle"},
	{8, 0x1C4, "DmNewRecord"},
	{8, 0x1C8, "DmNewResource"},
	{8, 0x1CC, "DmNextOpenDatabase"},
	{8, 0x1D0, "DmNextOpenResDatabase"},
	{8, 0x1D4, "DmNumDatabases"},
	{8, 0x1D8, "DmNumDatabasesV40"},
	{8, 0x1DC, "DmNumRecords"},
	{8, 0x1E0, "DmNumRecordsInCategory"},
	{8, 0x1E4, "DmNumResources"},
	{8, 0x1E8, "DmOpenDatabase"},
	{8, 0x1EC, "DmOpenDatabaseByTypeCreator"},
	{8, 0x1F0, "DmOpenDatabaseInfo"},
	{8, 0x1F4, "DmOpenDatabaseInfoV40"},
	{8, 0x1F8, "DmOpenDatabaseV40"},
	{8, 0x1FC, "DmOpenDBNoOverlay"},
	{8, 0x200, "DmOpenDBNoOverlayV40"},
	{8, 0x204, "DmOpenDBWithLocale"},
	{8, 0x208, "DmPositionInCategory"},
	{8, 0x20C, "DmQueryNextInCategory"},
	{8, 0x210, "DmQueryRecord"},
	{8, 0x214, "DmQuickSort"},
	{8, 0x218, "DmRecordInfo"},
	{8, 0x21C, "DmReleaseRecord"},
	{8, 0x220, "DmReleaseResource"},
	{8, 0x224, "DmRemoveRecord"},
	{8, 0x228, "DmRemoveResource"},
	{8, 0x22C, "DmRemoveSecretRecords"},
	{8, 0x230, "DmResetRecordStates"},
	{8, 0x234, "DmResizeRecord"},
	{8, 0x238, "DmResizeResource"},
	{8, 0x23C, "DmResourceInfo"},
	{8, 0x240, "DmSearchRecord"},
	{8, 0x244, "DmSearchResource"},
	{8, 0x248, "DmSeekRecordInCategory"},
	{8, 0x24C, "DmSet"},
	{8, 0x250, "DmSetDatabaseInfo"},
	{8, 0x254, "DmSetDatabaseInfoV40"},
	{8, 0x258, "DmSetRecordInfo"},
	{8, 0x25C, "DmSetResourceInfo"},
	{8, 0x260, "DmStrCopy"},
	{8, 0x264, "DmWrite"},
	{8, 0x268, "DmWriteCheck"},
	{8, 0x26C, "EncDES"},
	{8, 0x270, "EncDigestMD4"},
	{8, 0x274, "EncDigestMD5"},
	{8, 0x278, "ErrAlertCustom"},
	{8, 0x27C, "ErrDisplayFileLineMsg"},
	{8, 0x280, "ErrExceptionList"},
	{8, 0x284, "ErrThrow"},
	{8, 0x288, "EvtDequeueKeyEvent"},
	{8, 0x28C, "EvtDequeuePenPoint"},
	{8, 0x290, "EvtDequeuePenStrokeInfo"},
	{8, 0x294, "EvtEnableGraffiti"},
	{8, 0x298, "EvtEnqueueKey"},
	{8, 0x29C, "EvtEnqueuePenPoint"},
	{8, 0x2A0, "EvtFlushKeyQueue"},
	{8, 0x2A4, "EvtFlushNextPenStroke"},
	{8, 0x2A8, "EvtFlushPenQueue"},
	{8, 0x2AC, "EvtGetPen"},
	{8, 0x2B0, "EvtGetPenBtnList"},
	{8, 0x2B4, "EvtGetSilkscreenAreaList"},
	{8, 0x2B8, "EvtGetSysEvent"},
	{8, 0x2BC, "EvtKeyQueueEmpty"},
	{8, 0x2C0, "EvtKeyQueueSize"},
	{8, 0x2C4, "EvtPenQueueSize"},
	{8, 0x2C8, "EvtProcessSoftKeyStroke"},
	{8, 0x2CC, "EvtResetAutoOffTimer"},
	{8, 0x2D0, "EvtSetAutoOffTimer"},
	{8, 0x2D4, "EvtSetKeyQueuePtr"},
	{8, 0x2D8, "EvtSetNullEventTick"},
	{8, 0x2DC, "EvtSetPenQueuePtr"},
	{8, 0x2E0, "EvtSysEventAvail"},
	{8, 0x2E4, "EvtSysInit"},
	{8, 0x2E8, "EvtWakeup"},
	{8, 0x2EC, "EvtWakeupWithoutNilEvent"},
	{8, 0x2F0, "ExgAccept"},
	{8, 0x2F4, "ExgConnect"},
	{8, 0x2F8, "ExgControl"},
	{8, 0x2FC, "ExgDBRead"},
	{8, 0x300, "ExgDBReadV40"},
	{8, 0x304, "ExgDBWrite"},
	{8, 0x308, "ExgDBWriteV40"},
	{8, 0x30C, "ExgDisconnect"},
	{8, 0x310, "ExgDoDialog"},
	{8, 0x314, "ExgGet"},
	{8, 0x318, "ExgGetDefaultApplication"},
	{8, 0x31C, "ExgGetRegisteredApplications"},
	{8, 0x320, "ExgGetRegisteredTypes"},
	{8, 0x324, "ExgGetTargetApplication"},
	{8, 0x328, "ExgInit"},
	{8, 0x32C, "ExgNotifyGoto"},
	{8, 0x330, "ExgNotifyPreview"},
	{8, 0x334, "ExgNotifyReceive"},
	{8, 0x338, "ExgNotifyReceiveV35"},
	{8, 0x33C, "ExgPut"},
	{8, 0x340, "ExgReceive"},
	{8, 0x344, "ExgRegisterData"},
	{8, 0x348, "ExgRegisterDatatype"},
	{8, 0x34C, "ExgRequest"},
	{8, 0x350, "ExgSend"},
	{8, 0x354, "ExgSetDefaultApplication"},
	{8, 0x358, "ExgLibControl"},
	{8, 0x35C, "ExgLibGetLibraryRef"},
	{8, 0x360, "ExgLibHandleEvent"},
	{8, 0x364, "ExpCardGetSerialPort"},
	{8, 0x368, "ExpCardInfo"},
	{8, 0x36C, "ExpCardInserted"},
	{8, 0x370, "ExpCardPresent"},
	{8, 0x374, "ExpCardRemoved"},
	{8, 0x378, "ExpInit"},
	{8, 0x37C, "ExpSlotDriverInstall"},
	{8, 0x380, "ExpSlotDriverRemove"},
	{8, 0x384, "ExpSlotEnumerate"},
	{8, 0x388, "ExpSlotLibFind"},
	{8, 0x38C, "ExpSlotRegister"},
	{8, 0x390, "ExpSlotUnregister"},
	{8, 0x394, "FileClose"},
	{8, 0x398, "FileControl"},
	{8, 0x39C, "FileDelete"},
	{8, 0x3A0, "FileDeleteV40"},
	{8, 0x3A4, "FileOpen"},
	{8, 0x3A8, "FileOpenV40"},
	{8, 0x3AC, "FileReadLow"},
	{8, 0x3B0, "FileSeek"},
	{8, 0x3B4, "FileTell"},
	{8, 0x3B8, "FileTruncate"},
	{8, 0x3BC, "FileWrite"},
	{8, 0x3C0, "FindSaveMatchV40"},
	{8, 0x3C4, "FlpAToF"},
	{8, 0x3C8, "FlpBase10Info"},
	{8, 0x3CC, "FlpCorrectedAdd"},
	{8, 0x3D0, "FlpCorrectedSub"},
	{8, 0x3D4, "FlpFToA"},
	{8, 0x3D8, "FlpVersion"},
	{8, 0x3DC, "FntAverageCharWidth"},
	{8, 0x3E0, "FntBaseLine"},
	{8, 0x3E4, "FntCharHeight"},
	{8, 0x3E8, "FntCharsInWidth"},
	{8, 0x3EC, "FntCharsWidth"},
	{8, 0x3F0, "FntCharWidth"},
	{8, 0x3F4, "FntDefineFont"},
	{8, 0x3F8, "FntDescenderHeight"},
	{8, 0x3FC, "FntGetFont"},
	{8, 0x400, "FntGetFontPtr"},
	{8, 0x404, "FntGetScrollValues"},
	{8, 0x408, "FntLineHeight"},
	{8, 0x40C, "FntLineWidth"},
	{8, 0x410, "FntSetFont"},
	{8, 0x414, "FntWCharWidth"},
	{8, 0x418, "FntWidthToOffset"},
	{8, 0x41C, "FntWordWrap"},
	{8, 0x420, "FntWordWrapReverseNLines"},
	{8, 0x424, "FtrGet"},
	{8, 0x428, "FtrGetByIndex"},
	{8, 0x42C, "FtrInit"},
	{8, 0x430, "FtrPtrFree"},
	{8, 0x434, "FtrPtrNew"},
	{8, 0x438, "FtrPtrResize"},
	{8, 0x43C, "FtrSet"},
	{8, 0x440, "FtrUnregister"},
	{8, 0x444, "GetCharAttr"},
	{8, 0x448, "GetCharCaselessValue"},
	{8, 0x44C, "GetCharSortValue"},
	{8, 0x450, "TmOutputB"},
	{8, 0x454, "TmOutputT"},
	{8, 0x458, "TmOutputTL"},
	{8, 0x45C, "TmOutputVT"},
	{8, 0x460, "TmOutputVTL"},
	{8, 0x464, "HSUtilReverseDWord"},
	{8, 0x468, "HSUtilReverseWord"},
	{8, 0x46C, "ImcReadFieldNoSemicolon"},
	{8, 0x470, "ImcReadFieldQuotablePrintable"},
	{8, 0x474, "ImcReadPropertyParameter"},
	{8, 0x478, "ImcReadWhiteSpace"},
	{8, 0x47C, "ImcSkipAllPropertyParameters"},
	{8, 0x480, "ImcStringIsAscii"},
	{8, 0x484, "ImcWriteNoSemicolon"},
	{8, 0x488, "ImcWriteQuotedPrintable"},
	{8, 0x48C, "KeyCurrentState"},
	{8, 0x490, "KeyRates"},
	{8, 0x494, "KeySetMask"},
	{8, 0x498, "LmGetLocaleSetting"},
	{8, 0x49C, "LmGetNumLocales"},
	{8, 0x4A0, "LmLocaleToIndex"},
	{8, 0x4A4, "LocGetNumberSeparators"},
	{8, 0x4A8, "LstSetDrawFunctionV40"},
	{8, 0x4AC, "MdmDial"},
	{8, 0x4B0, "MdmHangUp"},
	{8, 0x4B4, "MemCardInfoV40"},
	{8, 0x4B8, "MemChunkFree"},
	{8, 0x4BC, "MemChunkNew"},
	{8, 0x4C0, "MemCmp"},
	{8, 0x4C4, "MemDebugMode"},
	{8, 0x4C8, "MemFormat"},
	{8, 0x4CC, "MemGetRomNVParams"},
	{8, 0x4D0, "MemHandleCardNoV40"},
	{8, 0x4D4, "MemHandleDataStorage"},
	{8, 0x4D8, "MemHandleFlags"},
	{8, 0x4DC, "MemHandleFree"},
	{8, 0x4E0, "MemHandleHeapID"},
	{8, 0x4E4, "MemHandleLock"},
	{8, 0x4E8, "MemHandleLockCount"},
	{8, 0x4EC, "MemHandleNew"},
	{8, 0x4F0, "MemHandleOwner"},
	{8, 0x4F4, "MemHandleResetLock"},
	{8, 0x4F8, "MemHandleResize"},
	{8, 0x4FC, "MemHandleSetOwner"},
	{8, 0x500, "MemHandleSize"},
	{8, 0x504, "MemHandleToLocalIDV40"},
	{8, 0x508, "MemHandleUnlock"},
	{8, 0x50C, "MemHeapCheck"},
	{8, 0x510, "MemHeapCompact"},
	{8, 0x514, "MemHeapDynamic"},
	{8, 0x518, "MemHeapFlags"},
	{8, 0x51C, "MemHeapFreeByOwnerID"},
	{8, 0x520, "MemHeapFreeBytes"},
	{8, 0x524, "MemHeapID"},
	{8, 0x528, "MemHeapIDV40"},
	{8, 0x52C, "MemHeapInit"},
	{8, 0x530, "MemHeapPtr"},
	{8, 0x534, "MemHeapScramble"},
	{8, 0x538, "MemHeapSize"},
	{8, 0x53C, "MemInfo"},
	{8, 0x540, "MemInit"},
	{8, 0x544, "MemKernelInit"},
	{8, 0x548, "MemLocalIDKindV40"},
	{8, 0x54C, "MemLocalIDToGlobalV40"},
	{8, 0x550, "MemLocalIDToLockedPtrV40"},
	{8, 0x554, "MemLocalIDToPtrV40"},
	{8, 0x558, "MemMove"},
	{8, 0x55C, "MemNumCardsV40"},
	{8, 0x560, "MemNumHeaps"},
	{8, 0x564, "MemNumHeapsV40"},
	{8, 0x568, "MemNumRAMHeaps"},
	{8, 0x56C, "MemNumRAMHeapsV40"},
	{8, 0x570, "MemNVParams"},
	{8, 0x574, "MemPtrCardNoV40"},
	{8, 0x578, "MemPtrDataStorage"},
	{8, 0x57C, "MemPtrFlags"},
	{8, 0x580, "MemPtrHeapID"},
	{8, 0x584, "MemPtrNew"},
	{8, 0x588, "MemPtrOwner"},
	{8, 0x58C, "MemPtrRecoverHandle"},
	{8, 0x590, "MemPtrResetLock"},
	{8, 0x594, "MemPtrResize"},
	{8, 0x598, "MemPtrSetOwner"},
	{8, 0x59C, "MemPtrSize"},
	{8, 0x5A0, "MemPtrToLocalIDV40"},
	{8, 0x5A4, "MemPtrUnlock"},
	{8, 0x5A8, "MemSemaphoreRelease"},
	{8, 0x5AC, "MemSemaphoreReserve"},
	{8, 0x5B0, "MemSet"},
	{8, 0x5B4, "MemSetDebugMode"},
	{8, 0x5B8, "MemStoreInfo"},
	{8, 0x5BC, "MemStoreInfoV40"},
	{8, 0x5C0, "MemStoreSearch"},
	{8, 0x5C4, "MemStoreSetInfo"},
	{8, 0x5C8, "MemStoreSetInfoV40"},
	{8, 0x5CC, "OmGetCurrentLocale"},
	{8, 0x5D0, "OmGetIndexedLocale"},
	{8, 0x5D4, "OmGetNextSystemLocale"},
	{8, 0x5D8, "OmGetSystemLocale"},
	{8, 0x5DC, "OmLocaleToOverlayDBName"},
	{8, 0x5E0, "OmOverlayDBNameToLocale"},
	{8, 0x5E4, "OmSetSystemLocale"},
	{8, 0x5E8, "PenCalibrate"},
	{8, 0x5EC, "PenResetCalibration"},
	{8, 0x5F0, "PrefGetAppPreferences"},
	{8, 0x5F4, "PrefGetAppPreferencesV10"},
	{8, 0x5F8, "PrefGetPreference"},
	{8, 0x5FC, "PrefGetPreferences"},
	{8, 0x600, "PrefOpenPreferenceDB"},
	{8, 0x604, "PrefOpenPreferenceDBV10"},
	{8, 0x608, "PrefSetAppPreferences"},
	{8, 0x60C, "PrefSetAppPreferencesV10"},
	{8, 0x610, "PrefSetPreference"},
	{8, 0x614, "PrefSetPreferences"},
	{8, 0x618, "PrvCncCreateDatabaseFromDefault"},
	{8, 0x61C, "PrvCncMgrInit"},
	{8, 0x620, "PrvCncPostHotSyncDBCleanup"},
	{8, 0x624, "PrvCncProfileBuildUniqueName"},
	{8, 0x628, "PrvCncProfileDuplicate"},
	{8, 0x62C, "PwdExists"},
	{8, 0x630, "PwdRemove"},
	{8, 0x634, "PwdSet"},
	{8, 0x638, "PwdVerify"},
	{8, 0x63C, "RctCopyRectangle"},
	{8, 0x640, "RctGetIntersection"},
	{8, 0x644, "RctInsetRectangle"},
	{8, 0x648, "RctOffsetRectangle"},
	{8, 0x64C, "RctPtInRectangle"},
	{8, 0x650, "RctSetRectangle"},
	{8, 0x654, "ScrCompress"},
	{8, 0x658, "ScrCompressScanLine"},
	{8, 0x65C, "ScrDecompress"},
	{8, 0x660, "ScrDeCompressScanLine"},
	{8, 0x664, "SecGetPwdHint"},
	{8, 0x668, "SecSetPwdHint"},
	{8, 0x66C, "SerialMgrInstall"},
	{8, 0x670, "SlkClose"},
	{8, 0x674, "SlkCloseSocket"},
	{8, 0x678, "SlkFlushSocket"},
	{8, 0x67C, "SlkOpen"},
	{8, 0x680, "SlkOpenSocket"},
	{8, 0x684, "SlkProcessRPC"},
	{8, 0x688, "SlkReceivePacket"},
	{8, 0x68C, "SlkSendPacket"},
	{8, 0x690, "SlkSetSocketListener"},
	{8, 0x694, "SlkSocketPortID"},
	{8, 0x698, "SlkSocketSetTimeout"},
	{8, 0x69C, "SlkSysPktDefaultResponse"},
	{8, 0x6A0, "SlotCardGetSerialPort"},
	{8, 0x6A4, "SlotCardInfo"},
	{8, 0x6A8, "SlotCardIsFilesystemSupported"},
	{8, 0x6AC, "SlotCardLowLevelFormat"},
	{8, 0x6B0, "SlotCardMediaType"},
	{8, 0x6B4, "SlotCardMetrics"},
	{8, 0x6B8, "SlotCardPresent"},
	{8, 0x6BC, "SlotCardRelease"},
	{8, 0x6C0, "SlotCardReserve"},
	{8, 0x6C4, "SlotCardSectorRead"},
	{8, 0x6C8, "SlotCardSectorWrite"},
	{8, 0x6CC, "SlotClose"},
	{8, 0x6D0, "SlotCustomControl"},
	{8, 0x6D4, "SlotOpen"},
	{8, 0x6D8, "SlotLibAPIVersion"},
	{8, 0x6DC, "SlotPowerCheck"},
	{8, 0x6E0, "SlotSleep"},
	{8, 0x6E4, "SlotWake"},
	{8, 0x6E8, "SndCreateMidiList"},
	{8, 0x6EC, "SndDoCmd"},
	{8, 0x6F0, "SndGetDefaultVolume"},
	{8, 0x6F4, "SndInit"},
	{8, 0x6F8, "SndPlaySmf"},
	{8, 0x6FC, "SndPlaySmfResource"},
	{8, 0x700, "SndPlaySystemSound"},
	{8, 0x704, "SndSetDefaultVolume"},
	{8, 0x708, "SrmClearErr"},
	{8, 0x70C, "SrmClose"},
	{8, 0x710, "SrmControl"},
	{8, 0x714, "SrmCustomControl"},
	{8, 0x718, "SrmExtOpen"},
	{8, 0x71C, "SrmExtOpenBackground"},
	{8, 0x720, "SrmGetDeviceCount"},
	{8, 0x724, "SrmGetDeviceInfo"},
	{8, 0x728, "SrmGetStatus"},
	{8, 0x72C, "SrmOpen"},
	{8, 0x730, "SrmOpenBackground"},
	{8, 0x734, "SrmPrimeWakeupHandler"},
	{8, 0x738, "SrmReceive"},
	{8, 0x73C, "SrmReceiveCheck"},
	{8, 0x740, "SrmReceiveFlush"},
	{8, 0x744, "SrmReceiveWait"},
	{8, 0x748, "SrmReceiveWindowClose"},
	{8, 0x74C, "SrmReceiveWindowOpen"},
	{8, 0x750, "SrmSend"},
	{8, 0x754, "SrmSendCheck"},
	{8, 0x758, "SrmSendFlush"},
	{8, 0x75C, "SrmSendWait"},
	{8, 0x760, "SrmSetReceiveBuffer"},
	{8, 0x764, "SrmSetWakeupHandler"},
	{8, 0x768, "SrmSleep"},
	{8, 0x76C, "SrmWake"},
	{8, 0x770, "StrAToI"},
	{8, 0x774, "StrCaselessCompare"},
	{8, 0x778, "StrCat"},
	{8, 0x77C, "StrChr"},
	{8, 0x780, "StrCompare"},
	{8, 0x784, "StrCompareAscii"},
	{8, 0x788, "StrCopy"},
	{8, 0x78C, "StrDelocalizeNumber"},
	{8, 0x790, "StrIToA"},
	{8, 0x794, "StrIToH"},
	{8, 0x798, "StrLen"},
	{8, 0x79C, "StrLocalizeNumber"},
	{8, 0x7A0, "StrNCaselessCompare"},
	{8, 0x7A4, "StrNCat"},
	{8, 0x7A8, "StrNCompare"},
	{8, 0x7AC, "StrNCompareAscii"},
	{8, 0x7B0, "StrNCopy"},
	{8, 0x7B4, "StrPrintF"},
	{8, 0x7B8, "StrStr"},
	{8, 0x7BC, "StrToLower"},
	{8, 0x7C0, "StrVPrintF"},
	{8, 0x7C4, "SysAppExit"},
	{8, 0x7C8, "SysAppLaunch"},
	{8, 0x7CC, "SysAppLaunchV40"},
	{8, 0x7D0, "SysAppStartup"},
	{8, 0x7D4, "SysAreWeUIThread"},
	{8, 0x7D8, "SysBatteryInfo"},
	{8, 0x7DC, "SysBatteryInfoV20"},
	{8, 0x7E0, "SysBatteryInfoV40"},
	{8, 0x7E4, "SysBinarySearch"},
	{8, 0x7E8, "SysBroadcastActionCode"},
	{8, 0x7EC, "SysCheckPwdTimeout"},
	{8, 0x7F0, "SysColdBoot"},
	{8, 0x7F4, "SysCopyStringResource"},
	{8, 0x7F8, "SysCreateDataBaseList"},
	{8, 0x7FC, "SysCreatePanelList"},
	{8, 0x800, "SysCurAppDatabase"},
	{8, 0x804, "SysCurAppDatabaseV40"},
	{8, 0x808, "SysCurAppInfoPV20"},
	{8, 0x80C, "SysDisableInts"},
	{8, 0x810, "SysErrString"},
	{8, 0x814, "SysEventAddToQueue"},
	{8, 0x818, "SysEventAddUniqueToQueue"},
	{8, 0x81C, "SysEventAvail"},
	{8, 0x820, "SysEventCopy"},
	{8, 0x824, "SysEventGet"},
	{8, 0x828, "SysEventInitialize"},
	{8, 0x82C, "SysFindModule"},
	{8, 0x830, "SysFormPointerArrayToStrings"},
	{8, 0x834, "SysGetAppInfo"},
	{8, 0x838, "SysGetEntryAddresses"},
	{8, 0x83C, "SysGetOSVersionString"},
	{8, 0x840, "SysGetROMToken"},
	{8, 0x844, "SysGetROMTokenV40"},
	{8, 0x848, "SysGetStackInfo"},
	{8, 0x84C, "SysHandleEvent"},
	{8, 0x850, "SysInit"},
	{8, 0x854, "SysInsertionSort"},
	{8, 0x858, "SysLCDBrightness"},
	{8, 0x85C, "SysLCDContrast"},
	{8, 0x860, "SysLibLoad"},
	{8, 0x864, "SysLibRemove"},
	{8, 0x868, "SysLibFindV40"},
	{8, 0x86C, "SysLibInstallV40"},
	{8, 0x870, "SysLibLoadV40"},
	{8, 0x874, "SysLibRemoveV40"},
	{8, 0x878, "SysLibTblEntry"},
	{8, 0x87C, "SysLinkerStub"},
	{8, 0x880, "SysLoadModule"},
	{8, 0x884, "SysNewOwnerID"},
	{8, 0x888, "SysNotifyBroadcast"},
	{8, 0x88C, "SysNotifyBroadcastDeferred"},
	{8, 0x890, "SysNotifyDatabaseAdded"},
	{8, 0x894, "SysNotifyDatabaseRemoved"},
	{8, 0x898, "SysNotifyInit"},
	{8, 0x89C, "SysNotifyRegister"},
	{8, 0x8A0, "SysNotifyRegisterV40"},
	{8, 0x8A4, "SysNotifyUnregister"},
	{8, 0x8A8, "SysNotifyUnregisterV40"},
	{8, 0x8AC, "SysNotifyBroadcastFromInterrupt"},
	{8, 0x8B0, "SysPatchEntry"},
	{8, 0x8B4, "SysQSort"},
	{8, 0x8B8, "SysRandom"},
	{8, 0x8BC, "SysReset"},
	{8, 0x8C0, "SysRestoreStatus"},
	{8, 0x8C4, "SysSetA5"},
	{8, 0x8C8, "SysSetAutoOffTime"},
	{8, 0x8CC, "SysSetDbgLockout"},
	{8, 0x8D0, "SysSetDevAutoLockTime"},
	{8, 0x8D4, "SysSetPwdTimeout"},
	{8, 0x8D8, "SysSleep"},
	{8, 0x8DC, "SysSleepV40"},
	{8, 0x8E0, "SysStringByIndex"},
	{8, 0x8E4, "SysTaskCreate"},
	{8, 0x8E8, "SysTaskDelay"},
	{8, 0x8EC, "SysTaskDelayV40"},
	{8, 0x8F0, "SysTaskDelete"},
	{8, 0x8F4, "SysTicksPerSecond"},
	{8, 0x8F8, "SysUIAppSwitch"},
	{8, 0x8FC, "SysUIAppSwitchV40"},
	{8, 0x900, "SysUIBusy"},
	{8, 0x904, "SysUILaunch"},
	{8, 0x908, "SysUnloadModule"},
	{8, 0x90C, "SysUnimplemented"},
	{8, 0x910, "SysWantEvent"},
	{8, 0x914, "TimAdjust"},
	{8, 0x918, "TimDateTimeToSeconds"},
	{8, 0x91C, "TimeToAscii"},
	{8, 0x920, "TimGetAlarm"},
	{8, 0x924, "TimGetSeconds"},
	{8, 0x928, "TimGetTicks"},
	{8, 0x92C, "TimSecondsToDateTime"},
	{8, 0x930, "TimSetAlarm"},
	{8, 0x934, "TimSetSeconds"},
	{8, 0x938, "TimTimeZoneToUTC"},
	{8, 0x93C, "TimUTCToTimeZone"},
	{8, 0x940, "TlsSetSystemData"},
	{8, 0x944, "TsmDrawMode"},
	{8, 0x948, "TsmFepCommitAction"},
	{8, 0x94C, "TsmFepHandleEvent"},
	{8, 0x950, "TsmFepMapEvent"},
	{8, 0x954, "TsmFepReset"},
	{8, 0x958, "TsmFepTerminate"},
	{8, 0x95C, "TsmGetCurrentFepCreator"},
	{8, 0x960, "TsmGetFepMode"},
	{8, 0x964, "TsmGetSystemFepCreator"},
	{8, 0x968, "TsmHandleEvent"},
	{8, 0x96C, "TsmInit"},
	{8, 0x970, "TsmSetCurrentFepCreator"},
	{8, 0x974, "TsmSetFepMode"},
	{8, 0x978, "TsmSetSystemFepCreator"},
	{8, 0x97C, "TxtByteAttr"},
	{8, 0x980, "TxtCaselessCompare"},
	{8, 0x984, "TxtCharAttr"},
	{8, 0x988, "TxtCharEncoding"},
	{8, 0x98C, "TxtCharIsValid"},
	{8, 0x990, "TxtCharWidth"},
	{8, 0x994, "TxtCharXAttr"},
	{8, 0x998, "TxtCharBounds"},
	{8, 0x99C, "TxtCharSize"},
	{8, 0x9A0, "TxtCompare"},
	{8, 0x9A4, "TxtConvertEncoding"},
	{8, 0x9A8, "TxtEncodingName"},
	{8, 0x9AC, "TxtFindString"},
	{8, 0x9B0, "TxtGetChar"},
	{8, 0x9B4, "TxtGetNextChar"},
	{8, 0x9B8, "TxtGetPreviousChar"},
	{8, 0x9BC, "TxtGetTruncationOffset"},
	{8, 0x9C0, "TxtGetWordWrapOffset"},
	{8, 0x9C4, "TxtMaxEncoding"},
	{8, 0x9C8, "TxtNameToEncoding"},
	{8, 0x9CC, "TxtParamString"},
	{8, 0x9D0, "TxtPrepFindString"},
	{8, 0x9D4, "TxtReplaceStr"},
	{8, 0x9D8, "TxtSetNextChar"},
	{8, 0x9DC, "TxtStrEncoding"},
	{8, 0x9E0, "TxtTransliterate"},
	{8, 0x9E4, "TxtWordBounds"},
	{8, 0x9E8, "UDAControl"},
	{8, 0x9EC, "UDAExchangeReaderNew"},
	{8, 0x9F0, "UDAExchangeWriterNew"},
	{8, 0x9F4, "UDAMemoryReaderNew"},
	{8, 0x9F8, "UDAFoldFilterNew"},
	{8, 0x9FC, "UDAUnfoldFilterNew"},
	{8, 0xA00, "UDAQPEncoderFilterNew"},
	{8, 0xA04, "UDAQPDecoderFilterNew"},
	{8, 0xA08, "UDAB64DecoderFilterNew"},
	{8, 0xA0C, "UDAB64EncoderFilterNew"},
	{8, 0xA10, "UDAEscapeFilterNew"},
	{8, 0xA14, "UDAUnEscapeFilterNew"},
	{8, 0xA18, "UDAPartFilterNew"},
	{8, 0xA1C, "UDAMemoryReaderNewTo68K"},
	{8, 0xA20, "UDAExchangeReaderNewTo68K"},
	{8, 0xA24, "UDAExchangeWriterNewTo68K"},
	{8, 0xA28, "UDAReaderToARM"},
	{8, 0xA2C, "UDAReaderTo68K"},
	{8, 0xA30, "UDAWriterToARM"},
	{8, 0xA34, "UDAWriterTo68K"},
	{8, 0xA38, "VFSCustomControl"},
	{8, 0xA3C, "VFSDirCreate"},
	{8, 0xA40, "VFSDirEntryEnumerate"},
	{8, 0xA44, "VFSExportDatabaseToFile"},
	{8, 0xA48, "VFSExportDatabaseToFileV40"},
	{8, 0xA4C, "VFSExportDatabaseToFileCustom"},
	{8, 0xA50, "VFSExportDatabaseToFileCustomV40"},
	{8, 0xA54, "VFSFileClose"},
	{8, 0xA58, "VFSFileCreate"},
	{8, 0xA5C, "VFSFileDBGetRecord"},
	{8, 0xA60, "VFSFileDBGetResource"},
	{8, 0xA64, "VFSFileDBInfo"},
	{8, 0xA68, "VFSFileDelete"},
	{8, 0xA6C, "VFSFileEOF"},
	{8, 0xA70, "VFSFileGetAttributes"},
	{8, 0xA74, "VFSFileGetDate"},
	{8, 0xA78, "VFSFileOpen"},
	{8, 0xA7C, "VFSFileRead"},
	{8, 0xA80, "VFSFileReadData"},
	{8, 0xA84, "VFSFileRename"},
	{8, 0xA88, "VFSFileResize"},
	{8, 0xA8C, "VFSFileSeek"},
	{8, 0xA90, "VFSFileSetAttributes"},
	{8, 0xA94, "VFSFileSetDate"},
	{8, 0xA98, "VFSFileSize"},
	{8, 0xA9C, "VFSFileTell"},
	{8, 0xAA0, "VFSFileWrite"},
	{8, 0xAA4, "VFSGetDefaultDirectory"},
	{8, 0xAA8, "VFSImportDatabaseFromFile"},
	{8, 0xAAC, "VFSImportDatabaseFromFileV40"},
	{8, 0xAB0, "VFSImportDatabaseFromFileCustom"},
	{8, 0xAB4, "VFSImportDatabaseFromFileCustomV40"},
	{8, 0xAB8, "VFSInit"},
	{8, 0xABC, "VFSInstallFSLib"},
	{8, 0xAC0, "VFSRegisterDefaultDirectory"},
	{8, 0xAC4, "VFSRemoveFSLib"},
	{8, 0xAC8, "VFSUnregisterDefaultDirectory"},
	{8, 0xACC, "VFSVolumeEnumerate"},
	{8, 0xAD0, "VFSVolumeFormat"},
	{8, 0xAD4, "VFSVolumeGetLabel"},
	{8, 0xAD8, "VFSVolumeInfo"},
	{8, 0xADC, "VFSVolumeMount"},
	{8, 0xAE0, "VFSVolumeSetLabel"},
	{8, 0xAE4, "VFSVolumeSize"},
	{8, 0xAE8, "VFSVolumeUnmount"},
	{8, 0xAEC, "WinAddWindow"},
	{8, 0xAF0, "WinClipRectangle"},
	{8, 0xAF4, "WinCopyRectangle"},
	{8, 0xAF8, "WinCreateBitmapWindow"},
	{8, 0xAFC, "WinCreateOffscreenWindow"},
	{8, 0xB00, "WinCreateWindow"},
	{8, 0xB04, "WinDeleteWindow"},
	{8, 0xB08, "WinDisableWindow"},
	{8, 0xB0C, "WinDisplayToWindowPt"},
	{8, 0xB10, "WinDrawBitmap"},
	{8, 0xB14, "WinDrawChar"},
	{8, 0xB18, "WinDrawChars"},
	{8, 0xB1C, "WinDrawGrayLine"},
	{8, 0xB20, "WinDrawGrayRectangleFrame"},
	{8, 0xB24, "WinDrawInvertedChars"},
	{8, 0xB28, "WinDrawLine"},
	{8, 0xB2C, "WinDrawPixel"},
	{8, 0xB30, "WinDrawRectangle"},
	{8, 0xB34, "WinDrawRectangleFrame"},
	{8, 0xB38, "WinDrawTruncChars"},
	{8, 0xB3C, "WinDrawWindowFrame"},
	{8, 0xB40, "WinEnableWindow"},
	{8, 0xB44, "WinEraseChars"},
	{8, 0xB48, "WinEraseLine"},
	{8, 0xB4C, "WinErasePixel"},
	{8, 0xB50, "WinEraseRectangle"},
	{8, 0xB54, "WinEraseRectangleFrame"},
	{8, 0xB58, "WinEraseWindow"},
	{8, 0xB5C, "WinFillLine"},
	{8, 0xB60, "WinFillRectangle"},
	{8, 0xB64, "WinGetActiveWindow"},
	{8, 0xB68, "WinGetBitmap"},
	{8, 0xB6C, "WinGetClip"},
	{8, 0xB70, "WinGetDisplayExtent"},
	{8, 0xB74, "WinGetDisplayWindow"},
	{8, 0xB78, "WinGetDrawWindow"},
	{8, 0xB7C, "WinGetDrawWindowBounds"},
	{8, 0xB80, "WinGetFirstWindow"},
	{8, 0xB84, "WinGetFramesRectangle"},
	{8, 0xB88, "WinGetPattern"},
	{8, 0xB8C, "WinGetPatternType"},
	{8, 0xB90, "WinGetPixel"},
	{8, 0xB94, "WinGetPixelRGB"},
	{8, 0xB98, "WinGetBounds"},
	{8, 0xB9C, "WinGetWindowExtent"},
	{8, 0xBA0, "WinGetWindowFrameRect"},
	{8, 0xBA4, "WinIndexToRGB"},
	{8, 0xBA8, "WinInitializeWindow"},
	{8, 0xBAC, "WinInvertChars"},
	{8, 0xBB0, "WinInvertLine"},
	{8, 0xBB4, "WinInvertPixel"},
	{8, 0xBB8, "WinInvertRectangle"},
	{8, 0xBBC, "WinInvertRectangleFrame"},
	{8, 0xBC0, "WinModal"},
	{8, 0xBC4, "WinMoveWindowAddr"},
	{8, 0xBC8, "WinPaintBitmap"},
	{8, 0xBCC, "WinPaintChar"},
	{8, 0xBD0, "WinPaintChars"},
	{8, 0xBD4, "WinPaintLine"},
	{8, 0xBD8, "WinPaintLines"},
	{8, 0xBDC, "WinPaintPixel"},
	{8, 0xBE0, "WinPaintPixels"},
	{8, 0xBE4, "WinPaintRectangle"},
	{8, 0xBE8, "WinPaintRectangleFrame"},
	{8, 0xBEC, "WinPalette"},
	{8, 0xBF0, "WinPopDrawState"},
	{8, 0xBF4, "WinPushDrawState"},
	{8, 0xBF8, "WinRemoveWindow"},
	{8, 0xBFC, "WinResetClip"},
	{8, 0xC00, "WinRestoreBits"},
	{8, 0xC04, "WinRGBToIndex"},
	{8, 0xC08, "WinSaveBits"},
	{8, 0xC0C, "WinScreenInit"},
	{8, 0xC10, "WinScreenLock"},
	{8, 0xC14, "WinScreenMode"},
	{8, 0xC18, "WinScreenUnlock"},
	{8, 0xC1C, "WinScrollRectangle"},
	{8, 0xC20, "WinSetActiveWindow"},
	{8, 0xC24, "WinSetBackColor"},
	{8, 0xC28, "WinSetBackColorRGB"},
	{8, 0xC2C, "WinSetClip"},
	{8, 0xC30, "WinSetColors"},
	{8, 0xC34, "WinSetDrawMode"},
	{8, 0xC38, "WinSetDrawWindow"},
	{8, 0xC3C, "WinSetForeColor"},
	{8, 0xC40, "WinSetForeColorRGB"},
	{8, 0xC44, "WinSetPattern"},
	{8, 0xC48, "WinSetPatternType"},
	{8, 0xC4C, "WinSetTextColor"},
	{8, 0xC50, "WinSetTextColorRGB"},
	{8, 0xC54, "WinSetUnderlineMode"},
	{8, 0xC58, "WinSetBounds"},
	{8, 0xC5C, "WinValidateHandle"},
	{8, 0xC60, "WinWindowToDisplayPt"},
	{8, 0xC64, "IntlSetStrictChecks"},
	{8, 0xC68, "BmpCreateBitmapV3"},
	{8, 0xC6C, "BmpGetCompressionType"},
	{8, 0xC70, "BmpGetDensity"},
	{8, 0xC74, "BmpGetNextBitmapAnyDensity"},
	{8, 0xC78, "BmpGetTransparentValue"},
	{8, 0xC7C, "BmpGetVersion"},
	{8, 0xC80, "BmpSetDensity"},
	{8, 0xC84, "BmpSetTransparentValue"},
	{8, 0xC88, "EvtGetPenNative"},
	{8, 0xC8C, "WinGetCoordinateSystem"},
	{8, 0xC90, "WinGetSupportedDensity"},
	{8, 0xC94, "WinPaintTiledBitmap"},
	{8, 0xC98, "WinSetCoordinateSystem"},
	{8, 0xC9C, "WinScalePoint"},
	{8, 0xCA0, "WinScaleRectangle"},
	{8, 0xCA4, "WinScreenGetAttribute"},
	{8, 0xCA8, "WinUnscalePoint"},
	{8, 0xCAC, "WinUnscaleRectangle"},
	{8, 0xCB0, "SysSleepWakeNotificationCallback"},
	{8, 0xCB4, "WinScaleCoord"},
	{8, 0xCB8, "WinUnscaleCoord"},
	{8, 0xCBC, "WinPaintRoundedRectangleFrame"},
	{8, 0xCC0, "SndPlaySmfIrregardless"},
	{8, 0xCC4, "SndPlaySmfResourceIrregardless"},
	{8, 0xCC8, "SndInterruptSmfIrregardless"},
	{8, 0xCCC, "Crc16CalcBigBlock"},
	{8, 0xCD0, "SlotMediaType"},
	{8, 0xCD4, "IntlInit"},
	{8, 0xCD8, "IntlHandleEvent"},
	{8, 0xCDC, "IntlGetRoutineAddress"},
	{8, 0xCE0, "OmGetRoutineAddress"},
	{8, 0xCE4, "OmInit"},
	{8, 0xCE8, "OmOpenOverlayDatabase"},
	{8, 0xCEC, "PenRestoreSavedCalibration"},
	{8, 0xCF0, "ScrCompressRLE"},
	{8, 0xCF4, "ScrDecompressRLE"},
	{8, 0xCF8, "ScrCompressPackBits"},
	{8, 0xCFC, "ScrCompressPackBits16"},
	{8, 0xD00, "ScrDecompressPackBits"},
	{8, 0xD04, "ScrDecompressPackBits16"},
	{8, 0xD08, "VFSPrvCleanupFiles"},
	{8, 0xD0C, "SndStreamCreate"},
	{8, 0xD10, "SndStreamDelete"},
	{8, 0xD14, "SndStreamStart"},
	{8, 0xD18, "SndStreamPause"},
	{8, 0xD1C, "SndStreamStop"},
	{8, 0xD20, "SndStreamSetVolume"},
	{8, 0xD24, "SndStreamGetVolume"},
	{8, 0xD28, "SndStreamSetPan"},
	{8, 0xD2C, "SndStreamGetPan"},
	{8, 0xD30, "SndPlayResource"},
	{8, 0xD34, "WinPrvInitCanvas"},
	{8, 0xD38, "WinPrvInitCanvasWithBitmap"},
	{8, 0xD3C, "WinPrvInitDrawState"},
	{8, 0xD40, "BmpPrvConvertBitmap"},
	{8, 0xD44, "BmpGetPixelFormat"},
	{8, 0xD48, "BmpCreateVersion3"},
	{8, 0xD4C, "WinGetBitmapDimensions"},
	{8, 0xD50, "SndStreamCreateExtended"},
	{8, 0xD54, "SndStreamDeviceControl"},
	{8, 0xD58, "WinSetScalingMode"},
	{8, 0xD5C, "WinGetScalingMode"},
	{8, 0xD60, "GrfAddMacro"},
	{8, 0xD64, "GrfAddPoint"},
	{8, 0xD68, "GrfCleanState"},
	{8, 0xD6C, "GrfDeleteMacro"},
	{8, 0xD70, "GrfFieldChange"},
	{8, 0xD74, "GrfFilterPoints"},
	{8, 0xD78, "GrfFindBranch"},
	{8, 0xD7C, "GrfFlushPoints"},
	{8, 0xD80, "GrfFree"},
	{8, 0xD84, "GrfGetAndExpandMacro"},
	{8, 0xD88, "GrfGetGlyphMapping"},
	{8, 0xD8C, "GrfGetMacro"},
	{8, 0xD90, "GrfGetMacroName"},
	{8, 0xD94, "GrfGetNumPoints"},
	{8, 0xD98, "GrfGetPoint"},
	{8, 0xD9C, "GrfGetState"},
	{8, 0xDA0, "GrfInit"},
	{8, 0xDA4, "GrfInitState"},
	{8, 0xDA8, "GrfMatch"},
	{8, 0xDAC, "GrfMatchGlyph"},
	{8, 0xDB0, "GrfProcessStroke"},
	{8, 0xDB4, "GrfSetState"},
	{8, 0xDB8, "GrfBeginStroke"},
	{8, 0xDBC, "SysGraffitiReferenceDialog"},
	{8, 0xDC0, "PINGetInputAreaState"},
	{8, 0xDC4, "PINSetInputAreaState"},
	{8, 0xDC8, "PINGetInputTriggerState"},
	{8, 0xDCC, "PINSetInputTriggerState"},
	{8, 0xDD0, "PINAltInputSystemEnabled"},
	{8, 0xDD4, "PINGetCurrentPinletName"},
	{8, 0xDD8, "PINSwitchToPinlet"},
	{8, 0xDDC, "PINCountPinlets"},
	{8, 0xDE0, "PINGetPinletInfo"},
	{8, 0xDE4, "PINSetInputMode"},
	{8, 0xDE8, "PINGetInputMode"},
	{8, 0xDEC, "PINClearPinletState"},
	{8, 0xDF0, "PINShowReferenceDialog"},
	{8, 0xDF4, "StatGetAttribute"},
	{8, 0xDF8, "StatShow"},
	{8, 0xDFC, "StatHide"},
	{8, 0xE00, "WinSetConstraintsSize"},
	{8, 0xE04, "PINPrvInit"},
	{8, 0xE08, "PINPrvGetInputUserState"},
	{8, 0xE0C, "PINPrvSetInputUserState"},
	{8, 0xE10, "PINPrvGetInputAreaInitialized"},
	{8, 0xE14, "PINPrvResetInputAreaInitialized"},
	{8, 0xE18, "LmGetLocaleSettingSize"},
	{8, 0xE1C, "WinPrvGetInputAreaBounds"},
	{8, 0xE20, "WinPrvScalePoint"},
	{8, 0xE24, "SysGetOrientation"},
	{8, 0xE28, "SysSetOrientation"},
	{8, 0xE2C, "SysGetOrientationTriggerState"},
	{8, 0xE30, "SysSetOrientationTriggerState"},
	{12, 0x000, "AbtShowAbout"},
	{12, 0x004, "AttnAllowClose"},
	{12, 0x008, "AttnDoEmergencySpecialEffects"},
	{12, 0x00C, "AttnDoSpecialEffects"},
	{12, 0x010, "AttnEffectOfEvent"},
	{12, 0x014, "AttnEnableNotification"},
	{12, 0x018, "AttnForgetIt"},
	{12, 0x01C, "AttnGetAttention"},
	{12, 0x020, "AttnGetCounts"},
	{12, 0x024, "AttnHandleEvent"},
	{12, 0x028, "AttnIterate"},
	{12, 0x02C, "AttnListOpen"},
	{12, 0x030, "AttnIndicatorAllow"},
	{12, 0x034, "AttnIndicatorAllowed"},
	{12, 0x038, "AttnIndicatorCheckBlink"},
	{12, 0x03C, "AttnIndicatorEnable"},
	{12, 0x040, "AttnIndicatorEnabled"},
	{12, 0x044, "AttnIndicatorGetBlinkPattern"},
	{12, 0x048, "AttnIndicatorSetBlinkPattern"},
	{12, 0x04C, "AttnIndicatorTicksTillNextBlink"},
	{12, 0x050, "AttnReopen"},
	{12, 0x054, "AttnUpdate"},
	{12, 0x058, "CategoryCreateList"},
	{12, 0x05C, "CategoryCreateListV10"},
	{12, 0x060, "CategoryEdit"},
	{12, 0x064, "CategoryEditV10"},
	{12, 0x068, "CategoryEditV20"},
	{12, 0x06C, "CategoryFind"},
	{12, 0x070, "CategoryFreeList"},
	{12, 0x074, "CategoryFreeListV10"},
	{12, 0x078, "CategoryGetName"},
	{12, 0x07C, "CategoryGetNext"},
	{12, 0x080, "CategoryInitialize"},
	{12, 0x084, "CategorySelect"},
	{12, 0x088, "CategorySelectV10"},
	{12, 0x08C, "CategorySetName"},
	{12, 0x090, "CategorySetTriggerLabel"},
	{12, 0x094, "CategoryTruncateName"},
	{12, 0x098, "ClipboardAddItem"},
	{12, 0x09C, "ClipboardAppendItem"},
	{12, 0x0A0, "ClipboardGetItem"},
	{12, 0x0A4, "CtlDrawControl"},
	{12, 0x0A8, "CtlEnabled"},
	{12, 0x0AC, "CtlEraseControl"},
	{12, 0x0B0, "CtlGetLabel"},
	{12, 0x0B4, "CtlGetSliderValues"},
	{12, 0x0B8, "CtlGetValue"},
	{12, 0x0BC, "CtlHandleEvent"},
	{12, 0x0C0, "CtlHideControl"},
	{12, 0x0C4, "CtlHitControl"},
	{12, 0x0C8, "CtlNewControl"},
	{12, 0x0CC, "CtlNewGraphicControl"},
	{12, 0x0D0, "CtlNewSliderControl"},
	{12, 0x0D4, "CtlSetEnabled"},
	{12, 0x0D8, "CtlSetGraphics"},
	{12, 0x0DC, "CtlSetLabel"},
	{12, 0x0E0, "CtlSetSliderValues"},
	{12, 0x0E4, "CtlSetUsable"},
	{12, 0x0E8, "CtlSetValue"},
	{12, 0x0EC, "CtlShowControl"},
	{12, 0x0F0, "CtlValidatePointer"},
	{12, 0x0F4, "DayDrawDays"},
	{12, 0x0F8, "DayDrawDaySelector"},
	{12, 0x0FC, "DayHandleEvent"},
	{12, 0x100, "Find"},
	{12, 0x104, "FindDrawHeader"},
	{12, 0x108, "FindGetLineBounds"},
	{12, 0x10C, "FindSaveMatch"},
	{12, 0x110, "FindStrInStr"},
	{12, 0x114, "FldCalcFieldHeight"},
	{12, 0x118, "FldCompactText"},
	{12, 0x11C, "FldCopy"},
	{12, 0x120, "FldCut"},
	{12, 0x124, "FldDelete"},
	{12, 0x128, "FldDirty"},
	{12, 0x12C, "FldDrawField"},
	{12, 0x130, "FldEraseField"},
	{12, 0x134, "FldFreeMemory"},
	{12, 0x138, "FldGetAttributes"},
	{12, 0x13C, "FldGetBounds"},
	{12, 0x140, "FldGetFont"},
	{12, 0x144, "FldGetInsPtPosition"},
	{12, 0x148, "FldGetMaxChars"},
	{12, 0x14C, "FldGetNumberOfBlankLines"},
	{12, 0x150, "FldGetScrollPosition"},
	{12, 0x154, "FldGetScrollValues"},
	{12, 0x158, "FldGetSelection"},
	{12, 0x15C, "FldGetTextAllocatedSize"},
	{12, 0x160, "FldGetTextHandle"},
	{12, 0x164, "FldGetTextHeight"},
	{12, 0x168, "FldGetTextLength"},
	{12, 0x16C, "FldGetTextPtr"},
	{12, 0x170, "FldGetVisibleLines"},
	{12, 0x174, "FldGrabFocus"},
	{12, 0x178, "FldHandleEvent"},
	{12, 0x17C, "FldInsert"},
	{12, 0x180, "FldMakeFullyVisible"},
	{12, 0x184, "FldNewField"},
	{12, 0x188, "FldPaste"},
	{12, 0x18C, "FldRecalculateField"},
	{12, 0x190, "FldReleaseFocus"},
	{12, 0x194, "FldScrollable"},
	{12, 0x198, "FldScrollField"},
	{12, 0x19C, "FldSendChangeNotification"},
	{12, 0x1A0, "FldSendHeightChangeNotification"},
	{12, 0x1A4, "FldSetAttributes"},
	{12, 0x1A8, "FldSetBounds"},
	{12, 0x1AC, "FldSetDirty"},
	{12, 0x1B0, "FldSetFont"},
	{12, 0x1B4, "FldSetInsertionPoint"},
	{12, 0x1B8, "FldSetInsPtPosition"},
	{12, 0x1BC, "FldSetMaxChars"},
	{12, 0x1C0, "FldSetMaxVisibleLines"},
	{12, 0x1C4, "FldSetScrollPosition"},
	{12, 0x1C8, "FldSetSelection"},
	{12, 0x1CC, "FldSetText"},
	{12, 0x1D0, "FldSetTextAllocatedSize"},
	{12, 0x1D4, "FldSetTextHandle"},
	{12, 0x1D8, "FldSetTextPtr"},
	{12, 0x1DC, "FldSetUsable"},
	{12, 0x1E0, "FldUndo"},
	{12, 0x1E4, "FldWordWrap"},
	{12, 0x1E8, "FontSelect"},
	{12, 0x1EC, "FrmActiveState"},
	{12, 0x1F0, "FrmAddSpaceForObject"},
	{12, 0x1F4, "FrmAlert"},
	{12, 0x1F8, "FrmCloseAllForms"},
	{12, 0x1FC, "FrmCopyLabel"},
	{12, 0x200, "FrmCopyTitle"},
	{12, 0x204, "FrmCustomAlert"},
	{12, 0x208, "FrmCustomResponseAlert"},
	{12, 0x20C, "FrmDeleteForm"},
	{12, 0x210, "FrmDispatchEvent"},
	{12, 0x214, "FrmDoDialog"},
	{12, 0x218, "FrmDrawForm"},
	{12, 0x21C, "FrmEraseForm"},
	{12, 0x220, "FrmGetActiveField"},
	{12, 0x224, "FrmGetActiveForm"},
	{12, 0x228, "FrmGetActiveFormID"},
	{12, 0x22C, "FrmGetControlGroupSelection"},
	{12, 0x230, "FrmGetControlValue"},
	{12, 0x234, "FrmGetFirstForm"},
	{12, 0x238, "FrmGetFocus"},
	{12, 0x23C, "FrmGetFormBounds"},
	{12, 0x240, "FrmGetFormId"},
	{12, 0x244, "FrmGetFormPtr"},
	{12, 0x248, "FrmGetGadgetData"},
	{12, 0x24C, "FrmGetLabel"},
	{12, 0x250, "FrmGetNumberOfObjects"},
	{12, 0x254, "FrmGetObjectBounds"},
	{12, 0x258, "FrmGetObjectId"},
	{12, 0x25C, "FrmGetObjectIndex"},
	{12, 0x260, "FrmGetObjectIndexFromPtr"},
	{12, 0x264, "FrmGetObjectPosition"},
	{12, 0x268, "FrmGetObjectPtr"},
	{12, 0x26C, "FrmGetObjectType"},
	{12, 0x270, "FrmGetTitle"},
	{12, 0x274, "FrmGetUserModifiedState"},
	{12, 0x278, "FrmGetWindowHandle"},
	{12, 0x27C, "FrmGotoForm"},
	{12, 0x280, "FrmHandleEvent"},
	{12, 0x284, "FrmHelp"},
	{12, 0x288, "FrmHideObject"},
	{12, 0x28C, "FrmInitForm"},
	{12, 0x290, "FrmNewBitmap"},
	{12, 0x294, "FrmNewForm"},
	{12, 0x298, "FrmNewGadget"},
	{12, 0x29C, "FrmNewGsi"},
	{12, 0x2A0, "FrmNewLabel"},
	{12, 0x2A4, "FrmPointInTitle"},
	{12, 0x2A8, "FrmPopupForm"},
	{12, 0x2AC, "FrmRemoveObject"},
	{12, 0x2B0, "FrmReturnToForm"},
	{12, 0x2B4, "FrmSaveAllForms"},
	{12, 0x2B8, "FrmSetActiveForm"},
	{12, 0x2BC, "FrmSetCategoryLabel"},
	{12, 0x2C0, "FrmSetControlGroupSelection"},
	{12, 0x2C4, "FrmSetControlValue"},
	{12, 0x2C8, "FrmSetEventHandler"},
	{12, 0x2CC, "FrmSetFocus"},
	{12, 0x2D0, "FrmSetGadgetData"},
	{12, 0x2D4, "FrmSetGadgetHandler"},
	{12, 0x2D8, "FrmSetMenu"},
	{12, 0x2DC, "FrmSetNotUserModified"},
	{12, 0x2E0, "FrmSetObjectBounds"},
	{12, 0x2E4, "FrmSetObjectPosition"},
	{12, 0x2E8, "FrmSetTitle"},
	{12, 0x2EC, "FrmShowObject"},
	{12, 0x2F0, "FrmUpdateForm"},
	{12, 0x2F4, "FrmUpdateScrollers"},
	{12, 0x2F8, "FrmValidatePtr"},
	{12, 0x2FC, "FrmVisible"},
	{12, 0x300, "GsiEnable"},
	{12, 0x304, "GsiEnabled"},
	{12, 0x308, "GsiInitialize"},
	{12, 0x30C, "GsiSetLocation"},
	{12, 0x310, "GsiSetShiftState"},
	{12, 0x314, "InsPtCheckBlink"},
	{12, 0x318, "InsPtEnable"},
	{12, 0x31C, "InsPtEnabled"},
	{12, 0x320, "InsPtGetHeight"},
	{12, 0x324, "InsPtGetLocation"},
	{12, 0x328, "InsPtInitialize"},
	{12, 0x32C, "InsPtSetHeight"},
	{12, 0x330, "InsPtSetLocation"},
	{12, 0x334, "KbdDraw"},
	{12, 0x338, "KbdErase"},
	{12, 0x33C, "KbdGetLayout"},
	{12, 0x340, "KbdGetPosition"},
	{12, 0x344, "KbdGetShiftState"},
	{12, 0x348, "KbdHandleEvent"},
	{12, 0x34C, "KbdSetLayout"},
	{12, 0x350, "KbdSetPosition"},
	{12, 0x354, "KbdSetShiftState"},
	{12, 0x358, "KeyboardStatusFree"},
	{12, 0x35C, "KeyboardStatusNew"},
	{12, 0x360, "LstDrawList"},
	{12, 0x364, "LstEraseList"},
	{12, 0x368, "LstGetNumberOfItems"},
	{12, 0x36C, "LstGetSelection"},
	{12, 0x370, "LstGetSelectionText"},
	{12, 0x374, "LstGetTopItem"},
	{12, 0x378, "LstGetVisibleItems"},
	{12, 0x37C, "LstHandleEvent"},
	{12, 0x380, "LstMakeItemVisible"},
	{12, 0x384, "LstNewList"},
	{12, 0x388, "LstPopupList"},
	{12, 0x38C, "LstScrollList"},
	{12, 0x390, "LstSetDrawFunction"},
	{12, 0x394, "LstSetHeight"},
	{12, 0x398, "LstSetListChoices"},
	{12, 0x39C, "LstSetPosition"},
	{12, 0x3A0, "LstSetSelection"},
	{12, 0x3A4, "LstSetTopItem"},
	{12, 0x3A8, "MenuAddItem"},
	{12, 0x3AC, "MenuCmdBarAddButton"},
	{12, 0x3B0, "MenuCmdBarDisplay"},
	{12, 0x3B4, "MenuCmdBarGetButtonData"},
	{12, 0x3B8, "MenuDispose"},
	{12, 0x3BC, "MenuDrawMenu"},
	{12, 0x3C0, "MenuEraseMenu"},
	{12, 0x3C4, "MenuEraseStatus"},
	{12, 0x3C8, "MenuGetActiveMenu"},
	{12, 0x3CC, "MenuHandleEvent"},
	{12, 0x3D0, "MenuHideItem"},
	{12, 0x3D4, "MenuInit"},
	{12, 0x3D8, "MenuSetActiveMenu"},
	{12, 0x3DC, "MenuSetActiveMenuRscID"},
	{12, 0x3E0, "MenuShowItem"},
	{12, 0x3E4, "PhoneNumberLookup"},
	{12, 0x3E8, "PhoneNumberLookupCustom"},
	{12, 0x3EC, "PrgHandleEvent"},
	{12, 0x3F0, "PrgStartDialog"},
	{12, 0x3F4, "PrgStartDialogV31"},
	{12, 0x3F8, "PrgStopDialog"},
	{12, 0x3FC, "PrgUpdateDialog"},
	{12, 0x400, "ResLoadConstant"},
	{12, 0x404, "ResLoadForm"},
	{12, 0x408, "ResLoadMenu"},
	{12, 0x40C, "SclDrawScrollBar"},
	{12, 0x410, "SclGetScrollBar"},
	{12, 0x414, "SclHandleEvent"},
	{12, 0x418, "SclSetScrollBar"},
	{12, 0x41C, "SecSelectViewStatus"},
	{12, 0x420, "SecVerifyPW"},
	{12, 0x424, "SelectDay"},
	{12, 0x428, "SelectDayV10"},
	{12, 0x42C, "SelectOneTime"},
	{12, 0x430, "SelectTime"},
	{12, 0x434, "SelectTimeV33"},
	{12, 0x438, "SelectTimeZone"},
	{12, 0x43C, "SysAppLauncherDialog"},
	{12, 0x440, "SysBatteryDialog"},
	{12, 0x444, "SysFatalAlert"},
	{12, 0x448, "SysFatalAlertInit"},
	{12, 0x44C, "SysKeyboardDialog"},
	{12, 0x450, "SysKeyboardDialogV10"},
	{12, 0x454, "TblDrawTable"},
	{12, 0x458, "TblEditing"},
	{12, 0x45C, "TblEraseTable"},
	{12, 0x460, "TblFindRowData"},
	{12, 0x464, "TblFindRowID"},
	{12, 0x468, "TblGetBounds"},
	{12, 0x46C, "TblGetColumnSpacing"},
	{12, 0x470, "TblGetColumnWidth"},
	{12, 0x474, "TblGetCurrentField"},
	{12, 0x478, "TblGetItemBounds"},
	{12, 0x47C, "TblGetItemFont"},
	{12, 0x480, "TblGetItemInt"},
	{12, 0x484, "TblGetItemPtr"},
	{12, 0x488, "TblGetLastUsableRow"},
	{12, 0x48C, "TblGetNumberOfRows"},
	{12, 0x490, "TblGetNumberOfColumns"},
	{12, 0x494, "TblGetRowData"},
	{12, 0x498, "TblGetRowHeight"},
	{12, 0x49C, "TblGetRowID"},
	{12, 0x4A0, "TblGetSelection"},
	{12, 0x4A4, "TblGetTopRow"},
	{12, 0x4A8, "TblGrabFocus"},
	{12, 0x4AC, "TblHandleEvent"},
	{12, 0x4B0, "TblHasScrollBar"},
	{12, 0x4B4, "TblInsertRow"},
	{12, 0x4B8, "TblMarkRowInvalid"},
	{12, 0x4BC, "TblMarkTableInvalid"},
	{12, 0x4C0, "TblRedrawTable"},
	{12, 0x4C4, "TblReleaseFocus"},
	{12, 0x4C8, "TblRemoveRow"},
	{12, 0x4CC, "TblRowInvalid"},
	{12, 0x4D0, "TblRowMasked"},
	{12, 0x4D4, "TblRowSelectable"},
	{12, 0x4D8, "TblRowUsable"},
	{12, 0x4DC, "TblSelectItem"},
	{12, 0x4E0, "TblSetBounds"},
	{12, 0x4E4, "TblSetColumnEditIndicator"},
	{12, 0x4E8, "TblSetColumnMasked"},
	{12, 0x4EC, "TblSetColumnSpacing"},
	{12, 0x4F0, "TblSetColumnUsable"},
	{12, 0x4F4, "TblSetColumnWidth"},
	{12, 0x4F8, "TblSetCustomDrawProcedure"},
	{12, 0x4FC, "TblSetItemFont"},
	{12, 0x500, "TblSetItemInt"},
	{12, 0x504, "TblSetItemPtr"},
	{12, 0x508, "TblSetItemStyle"},
	{12, 0x50C, "TblSetLoadDataProcedure"},
	{12, 0x510, "TblSetRowData"},
	{12, 0x514, "TblSetRowHeight"},
	{12, 0x518, "TblSetRowID"},
	{12, 0x51C, "TblSetRowMasked"},
	{12, 0x520, "TblSetRowSelectable"},
	{12, 0x524, "TblSetRowStaticHeight"},
	{12, 0x528, "TblSetRowUsable"},
	{12, 0x52C, "TblSetSaveDataProcedure"},
	{12, 0x530, "TblSetSelection"},
	{12, 0x534, "TblUnhighlightSelection"},
	{12, 0x538, "TimeZoneToAscii"},
	{12, 0x53C, "UIBrightnessAdjust"},
	{12, 0x540, "UIColorGetTableEntryIndex"},
	{12, 0x544, "UIColorGetTableEntryRGB"},
	{12, 0x548, "UIColorInit"},
	{12, 0x54C, "UIColorPopTable"},
	{12, 0x550, "UIColorPushTable"},
	{12, 0x554, "UIColorSetTableEntry"},
	{12, 0x558, "UIContrastAdjust"},
	{12, 0x55C, "UIInitialize"},
	{12, 0x560, "UIPickColor"},
	{12, 0x564, "UIGetGlobalsPtr"},
	{12, 0x568, "UIReset"},
	{12, 0x56C, "AttnInitialize"},
	{12, 0x570, "FrmGetDIAPolicyAttr"},
	{12, 0x574, "FrmSetDIAPolicyAttr"},
	{12, 0x578, "FrmPrvSetActiveFormPINAttributes"},
	{12, 0x57C, "FrmPrvRedrawDisplay"},
	{0, 0, NULL},
};


void palmosInstrNotify(uint32_t instr, uint32_t lr)
{
	static int tab = -1;
	
	if ((tab > 0) && ((instr & 0xfffff000) == 0xe59cf000)){
		
		const struct OsCall *c;
		
		for (c = mPalmOsCalls; c->name; c++) {
			if (c->tab != tab)
				continue;
			if (c->func != (instr & 0xfff))
				continue;
			break;
		}
		
		if (c->name)
			fprintf(stderr, "OSCALL %s from 0x%08x\n", c->name, lr);
		else
			fprintf(stderr, "OSCALL {%d, 0x%04x} from 0x%08x\n", tab, (instr & 0xfff), lr);
	}
	tab = ((instr & 0xfffffff0) == 0xe519c000) ? (int)(instr & 0x0f) : -1;
}